% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoweREST_gene.R
\name{PoweREST_gene}
\alias{PoweREST_gene}
\title{Bootstrap resampling and power estimation for one single gene}
\usage{
PoweREST_gene(Seurat_obj,cond,replicates=1,spots_num,
gene_name,iteration=100,random_seed=1,pvalue=0.05,...)
}
\arguments{
\item{Seurat_obj}{A \href{https://CRAN.R-project.org/package=Seurat}{Seurat} object.}

\item{cond}{The name of the variable that indicates different conditions which is also stored in the
meta.data of the Seurat_obj and should be in character type.}

\item{replicates}{The number of sample replicates per group.}

\item{spots_num}{The number of spots per replicate.}

\item{gene_name}{Specify the name of gene for power calculation.}

\item{iteration}{The number of iterations of the resampling.}

\item{random_seed}{To set a random seed.}

\item{pvalue}{The pvalue that will be considered significant.}

\item{...}{DE Test to use other than the default Wilcoxon test.}
}
\value{
A list of values containing the power, average log2FC and percentage of spots detecting the gene among
the resampling data, the replicate value and the spots number per slice specified by the user and corresponding gene's name.
}
\description{
This function performs bootstrap resampling upon a Seurat subject under each condition
to resemble the real dataset which allows the exact power calculation, and perform DE
analysis upon one gene specified by the user. Users can specify the test they would like
to perform for the DE analysis in '...'. Note that the results are not multiple testing
corrected, therefore should be interpreted carefully.
}
\author{
Lan Shui \email{lshui@mdanderson.org}
}
