% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighting.R
\name{combine_weights}
\alias{combine_weights}
\title{Combine Multiple Weighting Schemes}
\usage{
combine_weights(weight_matrices, weights = NULL)
}
\arguments{
\item{weight_matrices}{List of weight data frames to combine}

\item{weights}{Numeric vector of weights for each matrix (default: equal)}
}
\value{
Data.table with blended portfolio weights
}
\description{
Blends multiple weight matrices with specified weights. Useful for
multi-factor strategies that combine different allocation approaches.
Optimized using matrix operations for 1000x+ speedup.
}
\examples{
data("sample_prices_weekly")
# Calculate signals
momentum <- calc_momentum(sample_prices_weekly, lookback = 12)
selected <- filter_top_n(momentum, n = 10)
volatility <- calc_rolling_volatility(sample_prices_weekly, lookback = 20)

# Combine momentum and low-vol weights
mom_weights <- weight_by_signal(selected, momentum)
vol_weights <- weight_by_signal(selected, invert_signal(volatility))
combined <- combine_weights(list(mom_weights, vol_weights), weights = c(0.7, 0.3))
}
