% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uploadToDatabase.R
\name{insertResultsToSqlite}
\alias{insertResultsToSqlite}
\title{Create sqlite database with the results}
\usage{
insertResultsToSqlite(
  resultLocation,
  cohortDefinitions = NULL,
  databaseList = NULL,
  sqliteLocation = file.path(resultLocation, "sqlite"),
  skipDiagnostics = FALSE
)
}
\arguments{
\item{resultLocation}{(string) location of directory where the main package results were saved}

\item{cohortDefinitions}{A set of one or more cohorts extracted using ROhdsiWebApi::exportCohortDefinitionSet()}

\item{databaseList}{A list created by \code{createDatabaseList} to specify the databases}

\item{sqliteLocation}{(string) location of directory where the sqlite database will be saved}

\item{skipDiagnostics}{Whether to skip uploading the diagnostics}
}
\value{
Returns the location of the sqlite database file
}
\description{
This function create an sqlite database with the PLP result schema and inserts all results
}
\details{
This function can be used upload PatientLevelPrediction results into an sqlite database
}
\examples{
\dontshow{if (rlang::is_installed("RSQLite") && rlang::is_installed("Eunomia") && rlang::is_installed("curl") && curl::has_internet()) withAutoprint(\{ # examplesIf}
\donttest{ \dontshow{ # takes too long }
plpData <- getEunomiaPlpData()
saveLoc <- file.path(tempdir(), "insertResultsToSqlite")
results <- runPlp(plpData, outcomeId = 3, analysisId = 1, saveDirectory = saveLoc)
databaseFile <- insertResultsToSqlite(saveLoc, cohortDefinitions = NULL, 
                                      sqliteLocation = file.path(saveLoc, "sqlite"))
# check there is some data in the database
library(DatabaseConnector)
connectionDetails <- createConnectionDetails(
  dbms = "sqlite",
  server = databaseFile)
conn <- connect(connectionDetails)
# All tables should be created
getTableNames(conn, databaseSchema = "main")
# There is data in the tables
querySql(conn, "SELECT * FROM main.model_designs limit 10")
# clean up
unlink(saveLoc, recursive = TRUE)
}
\dontshow{\}) # examplesIf}
}
