#' Country-year level democratization data
#'
#' A dataset containing the democracy indicator for 184 countries from
#' 1960 to 2010
#'
#' \itemize{
#'   \item wbcode2. World Bank country ID. Integer.
#'   \item year. year (1960--2010). Integer.
#'   \item dem. binary indicator of democracy as defined in Acemoglu et al (2019).
#'   \item y log of GDP per capita in 2000 constant dollars (multiplied by 100). Numeric.
#'   \item tradewb Exports plus imports as a share of GDP from World Bank. Numeric.
#' }
#' @name dem
#' @docType data
#' @source Acemoglu, Daron, Suresh Naidu, Pascual Restrepo, and James
#' A Robinson. ``Democracy does cause growth.'' Journal of Political
#' Economy.
#' @format A data.frame containing 9384 rows and 3 variables
#' @keywords dataset
#'
NULL