% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.pugmm.R
\name{plot.pugmm}
\alias{plot.pugmm}
\title{Plotting method for \code{pugmm} object}
\usage{
\method{plot}{pugmm}(x, what = NULL, nrow = NULL, ncol = NULL, cluster_names = NULL, ...)
}
\arguments{
\item{x}{Output from \code{pugmm}.}

\item{what}{A string specifying the type of graph requested. Available choices are: \cr
\describe{
\item{\code{"BIC"}}{Plot of BIC values for the fitted models. For each \eqn{G}, the best BIC among the ones corresponding to different \eqn{m} is displayed.}
\item{\code{"Path Diagram"}}{Path diagram representation of the extended ultrametric covariance matrix per component for the best model.}}}

\item{nrow}{Number of rows in the graphical window. A new graphical window is opened every 6 plots, i.e., components of \code{pugmm}.}

\item{ncol}{Number of columns in the graphical window. A new graphical window is opened every 6 plots, i.e., components of \code{pugmm}.}

\item{cluster_names}{String of dimension \eqn{G} with the clusters/components' name.}

\item{...}{Other graphics parameters.}
}
\value{
No return value since this is a plot method.
}
\description{
Plots for Parsimonious Ultrametric Gaussian Mixture Models results, such as BIC and path diagrams.
}
\examples{
data(penguins)
x <- scale(penguins[, 2:5])
pugmm.penguins <- pugmm(x, 3, 1)
plot.pugmm(pugmm.penguins, what = c("BIC", "Path Diagram"))
}
\seealso{
\code{\link[=pugmm]{pugmm()}}
}
