% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_fusions.R
\name{extract_fusions}
\alias{extract_fusions}
\title{Extract fusion variants from text}
\usage{
extract_fusions(lines, mutations)
}
\arguments{
\item{lines}{Character vector. Lines of text to search for fusion variants.}

\item{mutations}{Character vector. List of mutations to look for.}
}
\value{
A list of fusion variants identified in the text.
}
\description{
This function identifies and extracts fusion variants from text lines based on specific patterns.
}
\examples{
InputPath <- system.file("extdata", package = "ORscraper")
files <- read_pdf_files(InputPath)
lines <- read_pdf_content(files[1])  # Example with the first file

genes_file <- system.file("extdata/Genes.xlsx", package = "ORscraper")
genes <- readxl::read_excel(genes_file)
mutations <- unique(genes$GEN)

fusions <- extract_fusions(lines, mutations)

}
