% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opi.r
\name{opiPresent}
\alias{opiPresent}
\title{Calls opiPresent_for_MACHINE as appropriate.}
\usage{
opiPresent(stim, ...)
}
\arguments{
\item{stim}{A stimulus object or list as described for each machine in the 'See Also' methods.}

\item{...}{Other arguments that might be needed by each machine in the 'See Also' methods.}
}
\value{
Each implementation should(!) return a list with at least the following elements:
\itemize{
\item \code{err} \code{NULL} if no error, otherwise a string describing the error.
\item \code{seen} \code{TRUE} if stimulus seen, \code{FALSE} otherwise
\item \code{time} Response time from onset of stimulus in milliseconds.
}
}
\description{
Specific parameters and return values can be seen in the machine specific versions
listed below in the ’See Also’.
}
\seealso{
\code{\link[=opiPresent_for_Compass]{opiPresent_for_Compass()}},
\code{\link[=opiPresent_for_Octopus900]{opiPresent_for_Octopus900()}},
\code{\link[=opiPresent_for_ImoVifa]{opiPresent_for_ImoVifa()}},
\code{\link[=opiPresent_for_PhoneHMD]{opiPresent_for_PhoneHMD()}}, \code{\link[=opiPresent_for_Display]{opiPresent_for_Display()}}, \code{\link[=opiPresent_for_PicoVR]{opiPresent_for_PicoVR()}},
\code{\link[=opiPresent_for_SimNo]{opiPresent_for_SimNo()}}, \code{\link[=opiPresent_for_SimYes]{opiPresent_for_SimYes()}}, \code{\link[=opiPresent_for_SimHenson]{opiPresent_for_SimHenson()}},
\code{\link[=opiPresent_for_SimHensonRT]{opiPresent_for_SimHensonRT()}},
\code{\link[=opiPresent_for_SimGaussian]{opiPresent_for_SimGaussian()}}
}
