% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoissonInvSGZ.r
\name{PoissonInvSGZ}
\alias{PoissonInvSGZ}
\alias{dpois.inv.sgz}
\alias{ppois.inv.sgz}
\alias{qpois.inv.sgz}
\alias{rpois.inv.sgz}
\alias{hpois.inv.sgz}
\title{Poisson Inverse Shifted Gompertz (PISG) Distribution}
\usage{
dpois.inv.sgz(x, alpha, beta, lambda, log = FALSE)
ppois.inv.sgz(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qpois.inv.sgz(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rpois.inv.sgz(n, alpha, beta, lambda)
hpois.inv.sgz(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dpois.inv.sgz}: numeric vector of (log-)densities
  \item \code{ppois.inv.sgz}: numeric vector of probabilities
  \item \code{qpois.inv.sgz}: numeric vector of quantiles
  \item \code{rpois.inv.sgz}: numeric vector of random variates
  \item \code{hpois.inv.sgz}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Poisson Inverse Shifted Gompertz distribution.
}
\details{
The Poisson Inverse Shifted Gompertz distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Poisson Inverse Shifted Gompertz distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
1 - \frac{1}{{\left( {1 - {e^{ - \lambda }}} \right)}}\left[ {1 - \exp 
\left\{ { - \lambda \left( {1 - {e^{ - \beta /x}}} \right)\exp 
\left( { - \alpha {e^{ - \beta /x}}} \right)} \right\}} \right]\quad ;\;x > 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The following functions are included:
\itemize{
  \item \code{dpois.inv.sgz()} — Density function
  \item \code{ppois.inv.sgz()} — Distribution function
  \item \code{qpois.inv.sgz()} — Quantile function
  \item \code{rpois.inv.sgz()} — Random generation
  \item \code{hpois.inv.sgz()} — Hazard function
}
}
\examples{
x <- seq(0.1, 10, 0.2)
dpois.inv.sgz(x, 2.0, 0.5, 0.2)
ppois.inv.sgz(x, 2.0, 0.5, 0.2)
qpois.inv.sgz(0.5, 2.0, 0.5, 0.2)
rpois.inv.sgz(10, 2.0, 0.5, 0.2)
hpois.inv.sgz(x, 2.0, 0.5, 0.2)

# Data
x <- fibers69  
# ML estimates
params = list(alpha=98.0893, beta=10.6326, lambda=2.1006)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = ppois.inv.sgz, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qpois.inv.sgz, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dpois.inv.sgz, pfun=ppois.inv.sgz, plot=FALSE)
print.gofic(out)

}
\references{
Sapkota, L. P., Kumar, V., Tekle, G., Alrweili, H., Mustafa, M. S., & 
Yusuf, M. (2025). Fitting Real Data Sets by a New Version of Gompertz 
Distribution. \emph{Modern Journal of Statistics}, \bold{1(1)}, 25--48.  
\doi{10.64389/mjs.2025.01109}
}
