% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cascade.R
\name{subset_cascade}
\alias{subset_cascade}
\title{Select a subset of cascades from cascade object}
\usage{
subset_cascade(cascade, selection)
}
\arguments{
\item{cascade}{cascade, object to select from}

\item{selection}{character or integer, vector of cascade_ids to select}
}
\value{
An object of class cascade containing just the selected cascades
}
\description{
Select a subset of cascades from cascade object
}
\examples{

data(policies)
cascades <- as_cascade_long(policies, cascade_node_name = 'statenam', 
                            event_time = 'adopt_year', cascade_id = 'policy')
cascade_names <- names(cascades$cascade_times)
subset_cascade(cascades, selection = cascade_names[1:10])

}
