#' Calculate Partial N Balance (PNB)
#' @description
#' The expression of plant N content per unit of fertilizer N applied.
#' Formula: PNB = PlantNf / FertN
#' @param PlantNf A numeric vector of Plant N content in fertilized conditions.
#' @param FertN A numeric value or vector for fertilizer N input.
#' @return A numeric vector of PNB values.
#' @examples
#' PlantNf <- c(3.5, 4.0, 4.2)
#' FertN <- 50
#' PNB(PlantNf, FertN)
#' @export
PNB <- function(PlantNf, FertN) {
  if (any(FertN == 0)) stop("FertN cannot be zero.")
  return(PlantNf / FertN)
}