% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.cullingtime.R
\name{get.cullingtime}
\alias{get.cullingtime}
\title{Derive time of culling}
\usage{
get.cullingtime(
  population,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  id = NULL,
  use.id = FALSE
)
}
\arguments{
\item{population}{Population list}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{id}{Individual IDs to search/collect in the database}

\item{use.id}{Set to TRUE to use MoBPS ids instead of Sex_Nr_Gen based names (default: FALSE)}
}
\value{
Time of death of in gen/database/cohorts selected individuals
}
\description{
Function to derive the time of culling for all individuals
}
\examples{
data(ex_pop)
get.cullingtime(ex_pop, gen=2)
}
