% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVNGmod.R
\name{MVNIGmod}
\alias{MVNIGmod}
\title{AECM Estimation for Matrix-Variate Normal-Inverse Gaussian Models}
\usage{
MVNIGmod(Y, X, theta_g = NULL, stopping = 0.001, max_iter = 50)
}
\arguments{
\item{Y}{List of \eqn{n_i \times p} response matrices. Matrices must have same number of columns.}

\item{X}{List of \eqn{n_i \times q} design matrices. Matrices must have same number of columns.}

\item{theta_g}{List of parameters to pass as initial values in the AECM algorithm.
If NULL, will be randomly generated. See Details for an in-depth explanation.}

\item{stopping}{Stopping threshold for the L-infinity norm of differences in consecutive parameter space, evaluated at iteration \eqn{t+1} as
\eqn{|\hat\theta^{t+1} - \hat\theta^{t}|_\infty}. Default is 0.001}

\item{max_iter}{Maximum number of iterations, default is 50.}
}
\value{
MVNIGmod returns a list with the following elements:

\describe{
\item{\code{Iteration}: }{Number of iterations taken to convergence. \code{Inf} if convergence not reached.}
\item{\verb{Starting Value}: }{List of initial parameter values.}
\item{\verb{Final Value}: }{List of final parameter estimates.}
\item{\verb{Stopping Criteria}: }{Vector of \eqn{|\hat\theta^{t+1} - \hat\theta^{t}|_\infty} at each iteration.}
\item{\code{AIC}: }{Model AIC}
\item{\code{BIC}: }{Model BIC}
}
}
\description{
This function fits MVNIG linear models for matrix-variate skew data with non-uniform data rows between subjects. Exchangeable observation row correlation
and skewness structures are imposed to accommodate the varying row counts
across matrices. Note that multiple restarts may be needed to account for unstable local maxima.
}
\details{
Fits the matrix-variate skew regression model

\deqn{Y_i = X_i \Theta + E_i,}

where each response \eqn{Y_i} is a \eqn{n_i \times p} matrix that indexes \eqn{n_i} observations and \eqn{p} response variables. \eqn{X_i} corresponds to a \eqn{n_i \times q} design matrix, and \eqn{\Theta} corresponds to a \eqn{q \times p} coefficient matrix. \eqn{E_i} corresponds to a \eqn{n_i \times p} error matrix, following a matrix-variate variance-gamma distribution.

The model estimates MVVG parameters \eqn{\Theta, \underline{a}, r, \Psi, \tilde\gamma} using the alternating expectation conditional maximization (AECM) algorithm, using the density

\deqn{f(Y_i|M_i,\underline{a},r, \Psi, \tilde\gamma, n_i, p) = \dfrac{2 \exp[matlib::tr(\Sigma_i^{-1}(Y_i-M_i)\Psi^{-1}A_i^T) + \tilde\gamma]}{(2\pi)^{\frac{n_ip}{2} + 1} |\Sigma_i|^{\frac{p}{2}} |\Psi|^{\frac{n_i}{2}}} \bigg( \dfrac{\delta(Y_i; M_i, \Sigma_i, \Psi) + 1}{\rho (A_i, \Sigma_i,\Psi) + \tilde\gamma^2} \bigg)^{-\frac{(1+n_ip)}{4}} \\ \times K_{-\frac{(1+n_ip)}{2}} \big( \sqrt{[\rho(A_i, \Sigma_i, \Psi) + \tilde\gamma^2][\delta(Y_i;M_i,\Sigma_i,\Psi) + 1]} \big),}

where \eqn{A_i = \underline{1}_{n_i} \times \underline{a}^T}, \eqn{\Sigma_i = I_{n_i} + r(\underline{1}_{n_i}\underline{1}_{n_i}^T - I_{n_i})},
\eqn{\delta(X;M, \Sigma, \Psi) = matlib::tr(\Sigma^{-1}(X-M)\Psi^{-1}(X-M)^T)}, \eqn{\rho(A, \Sigma, \Psi) = matlib::tr(\Sigma^{-1}A\Psi^{-1}A^T)}, and \eqn{K_{\nu}(x)} is the modified Bessel function of the second kind.

The structure of \code{theta_g} and parameter estimates returned by the function must be in the form of a list with the following named elements:

\describe{
\item{\code{Theta}: }{\eqn{q \times p} coefficient matrix}
\item{\code{a}: }{\eqn{p \times 1} skewness vector}
\item{\code{rho}: }{Compound symmetry parameter for row correlation matrix}
\item{\code{Psi}: }{\eqn{p \times p} column covariance matrix}
\item{\code{tgamma}: }{Univariate mixing parameter}
}
}
\examples{

MVNIGmod(Y,X,theta_mvnig)

\donttest{set.seed(1234)
# num response variables
p <- ncol(gaad_res[[1]])
# num covariates
q <- ncol(gaad_cov[[1]])
# generate initial value to input, then run AECM with MVVG distribution
initial_mvnig_theta <- list(Theta = matrix(stats::rnorm(p*q), nrow = q, ncol = p),
                      A = rep(1,p),
                     rho = 0.3,
                     Psi = diag(p),
                     tgamma = 3)
MVNIGmod(gaad_res[1:10], gaad_cov[1:10], initial_mvnig_theta)}

}
\author{
Samuel Soon

Dipankar Bandyopadhyay

Qingyang Liu
}
