% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maivefunction.r
\name{waive}
\alias{waive}
\title{WAIVE: More Aggressive Correction for P-Hacking and Spurious Precision}
\usage{
waive(
  dat,
  method,
  weight,
  instrument,
  studylevel,
  SE,
  AR,
  first_stage = 0L,
  estimate = NULL,
  se = NULL,
  n = NULL,
  study_id = NULL,
  seed = 123
)
}
\arguments{
\item{dat}{Data frame with columns bs, sebs, Ns, study_id (optional).}

\item{method}{1 FAT-PET, 2 PEESE, 3 PET-PEESE, 4 EK.}

\item{weight}{0 no weights, 1 standard weights, 2 MAIVE adjusted weights, 3 study weights.}

\item{instrument}{1 yes, 0 no.}

\item{studylevel}{Correlation at study level: 0 none, 1 fixed effects, 2 cluster.}

\item{SE}{SE estimator: 0 CR0 (Huber-White), 1 CR1 (Standard empirical correction),
2 CR2 (Bias-reduced estimator), 3 wild bootstrap.}

\item{AR}{Anderson Rubin corrected CI for weak instruments (available for unweighted and MAIVE-adjusted weight versions of
PET, PEESE, PET-PEESE, not available for fixed effects): 0 no, 1 yes.}

\item{first_stage}{First-stage specification for the variance model: 0 levels, 1 log.}

\item{estimate}{Optional column name to use instead of 'bs'}

\item{se}{Optional column name to use instead of 'sebs'}

\item{n}{Optional column name to use instead of 'Ns'}

\item{study_id}{Optional column name for study identifiers}

\item{seed}{Seed for the wild bootstrap when SE = 3. Use NULL to avoid setting a seed
(results depend on the current RNG state). Default is 123 for historical reproducibility.}
}
\value{
List with the same structure as \code{maive()}. See \code{?maive} for details.
}
\description{
WAIVE (Weighted Adjusted Instrumental Variable Estimator) provides a more
aggressive correction for p-hacking and spurious precision by extending MAIVE
with exponential-decay weights that downweight both spuriously precise
estimates and extreme outliers.
}
\details{
Guided, interactive workflow available at https://www.easymeta.org.

For technical details on WAIVE methodology, see: \url{https://meta-analysis.cz/waive_ottawa.pdf}


WAIVE combines variance instrumentation (as in MAIVE) with robust downweighting
based on first-stage residuals. Studies with negative residuals (spurious
precision) or extreme residuals (outliers) receive exponentially reduced
influence in the meta-analytic estimate. This makes WAIVE more aggressive than
standard MAIVE at correcting for p-hacking and handling outliers.
}
\examples{
dat <- data.frame(
  bs = c(0.5, 0.45, 0.55, 0.6),
  sebs = c(0.25, 0.2, 0.22, 0.27),
  Ns = c(50, 80, 65, 90)
)

result <- waive(dat,
  method = 3, weight = 0, instrument = 1,
  studylevel = 0, SE = 0, AR = 0, first_stage = 0
)

}
