% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_api_key.R
\name{save_api_keys}
\alias{save_api_keys}
\title{Saves Web of Science and/or Scopus API keys in .Renviron.}
\usage{
save_api_keys(wos_api_key = NULL, scp_api_key = NULL, dry_run = FALSE)
}
\arguments{
\item{wos_api_key}{The API key value for Web of Science (use quotation marks).}

\item{scp_api_key}{The API key value for Scopus (use quotation marks).}

\item{dry_run}{Simulation run option.}
}
\value{
Logical. TRUE if at least one value was written, FALSE if left unchanged.
}
\description{
You can set wos_api_key, scp_api_key, or both at the same time.
Remember to restart the R session after saving your API keys.
}
\examples{
save_api_keys(wos_api_key = "abcd01234",
               scp_api_key = "efgh5678",
               dry_run = TRUE
               )

}
