% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Labelling_and_plotting_functions.R
\name{get_relations}
\alias{get_relations}
\title{Compute and Label Pairwise Relationships Across Multiple Family Graphs}
\usage{
get_relations(
  family_graphs,
  fid = "fid",
  family_id_vec = NULL,
  fam_graph_col = "fam_graph"
)
}
\arguments{
\item{family_graphs}{A tibble containing family-specific graph objects
from \code{\link[=get_family_graphs]{get_family_graphs()}} (typically of class \code{igraph}). Each row should correspond to a
distinct family, with one column containing the graph object and another
containing the family identifier (typically the proband's id).}

\item{fid}{A character string specifying the name of the column in
\code{family_graphs} that holds the family identifiers. Defaults to \code{"fid"}.}

\item{family_id_vec}{An optional character or numeric vector specifying
which families to process. If \code{NULL} (default), the function will process
all families in \code{family_graphs}.}

\item{fam_graph_col}{A character string specifying the name of the column
in \code{family_graphs} that contains the family graph objects. Defaults to \code{"fam_graph"}.}
}
\value{
A tibble containing all labelled pairwise relationships across the specified
families, with columns:
\describe{
\item{fid}{Family identifier (typically the proband's id).}
\item{id1, id2}{Identifiers for the two individuals being compared.}
\item{gen.x, gen.y}{Number of generations separating each individual
from their most recent common ancestor.}
\item{k}{Kinship coefficient between the pair.}
\item{lab}{Relationship label (e.g., \code{"S"}, \code{"P"}, \code{"GP"}, \code{"1C"}, \code{"HNib"}).}
}
}
\description{
Applies \code{\link[=get_generations]{get_generations()}} and \code{\link[=label_relatives]{label_relatives()}} to a tibble of
family graph objects from \code{\link[=get_family_graphs]{get_family_graphs()}}, returning a unified table of labelled pairwise relationships
for all individuals across the specified families.
}
\examples{
# See vignette

}
\seealso{
\code{\link[=get_generations]{get_generations()}} for computing generational distances and kinship coefficients,
\code{\link[=label_relatives]{label_relatives()}} for labelling relationships based on generational patterns.
}
