% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Covariance_Estimator.R
\name{estimate_cov_raw}
\alias{estimate_cov_raw}
\title{Covariance estimator with missing data}
\usage{
estimate_cov_raw(X)
}
\arguments{
\item{X}{Numeric matrix (or object coercible to a matrix) containing covariates.
Rows correspond to observations and columns to variables. Missing values
(\code{NA}) are allowed.}
}
\value{
A numeric \code{p x p} matrix containing the estimated covariance matrix,
where \code{p = ncol(X)}. Entries corresponding to variable pairs that are
never jointly observed are \code{NA}.
}
\description{
Estimates the covariance matrix of a design matrix in the presence of
missing values. Each covariance entry is computed using all observations
for which the corresponding pair of covariates is jointly observed.
}
\details{
Let \eqn{X_{ij}} denote the \eqn{j}-th covariate for observation \eqn{i}.
For each pair of variables \eqn{(j, k)}, the covariance estimate is
\deqn{
\hat{\Sigma}_{jk}
=
\frac{1}{n_{jk}} \sum_{i : X_{ij}, X_{ik} \ \mathrm{observed}} X_{ij} X_{ik},
}
where \eqn{n_{jk}} is the number of observations for which both entries are
observed. If no such observations exist, the corresponding covariance entry
is set to \code{NA}.

This estimator is symmetric by construction and reduces to the usual sample
second-moment matrix when the data contain no missing values.
}
\examples{
set.seed(1)
X <- matrix(rnorm(25), 25, 5)
X[sample(length(X), 10)] <- NA
Sigma_hat <- estimate_cov_raw(X)
Sigma_hat


}
