% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/my_functions.R
\name{infoset}
\alias{infoset}
\title{Procedure to find the most-left distribution set.}
\usage{
infoset(y, plot_cp)
}
\arguments{
\item{y}{object of class "g_ret"}

\item{plot_cp}{option}
}
\value{
An object of class "infoset" is a list containing the following components for the firse two iterations (k=2):
 \describe{
 \item{change.points}{a vector of change points.}
 \item{prior.probability}{the a priori probabilities.}
 \item{first.type.errors}{the cumulative distribution functions associated with the leftmost component of the mixture.}
 \item{second.type.errors}{the cumulative distribution functions associated with the rightmost component of the mixture.}
 \item{mean}{the parameters (drift) of the left-hand component of the log-normal mixture.}
 \item{sd}{the parameters (volatility) of the left-hand component of the log-normal mixture.}
}
}
\description{
Estimation of the vector of unknown parameters for the density functions associated with the
two mixture components.
}
\examples{

\donttest{gross.ret<-as.data.frame(lapply(sample.data, g_ret))
infoset(gross.ret$ETF_1, plot_cp = "T")}

############################################################
## EXAMPLE 1: Clustering ETFs
############################################################

\donttest{
gross.ret<-as.data.frame(lapply(sample.data, g_ret))
result<-NULL
for(i in 1:ncol(gross.ret)){
 result[[i]]<-infoset(gross.ret[,i], plot_cp = "F")
}
output<-matrix(unlist(result),12,ncol=ncol(gross.ret)) # output contains the information set
output<-t(output)
rownames(output)<-colnames(gross.ret)
colnames(output)<-c("ch_1","ch_2","priori_1","priori_2","first_1",
                   "first_2","second_1","second_2","mean_1","mean_2","dev_1", "dev_2")
output<- as.data.frame(output)
group_label <- as.factor(asset.label$label)
d <- dist(output, method = 'euclidean')
hc_SIMS <- hclust(d, method = 'complete')
library(dendextend)
library(colorspace)
dend_SIMS <- as.dendrogram(hc_SIMS)
dend_SIMS <- color_branches(dend_SIMS, k = 4, col = c(1:4))
labels_colors(dend_SIMS) <-
       rainbow_hcl(5)[sort_levels_values(as.numeric(group_label)[order.dendrogram(dend_SIMS)])]
labels(dend_SIMS) <- paste(as.character(group_label)[order.dendrogram(dend_SIMS)],
       '(', labels(dend_SIMS), ')', sep = '')
dend_SIMS <- hang.dendrogram(dend_SIMS, hang_height = 0.001)
dend_SIMS <- assign_values_to_leaves_nodePar(dend_SIMS, 0.5, 'lab.cex')
dev.new()
old_par <- par(no.readonly = TRUE)
on.exit(par(old_par))
par(mar = c(1.8, 1.8, 1.8, 1))
plot(dend_SIMS, main = 'Complete linkage (the labels give the true ETF class)',
     horiz = TRUE, nodePar = list(cex = 0.007))
legend('topleft', legend = c('emerging equity Asia', 'emerging equity America',
                           'corporate bond', 'commodities', 'aggregate bond'),
             fill = c('#BDAB66', '#65BC8C', '#C29DDE', '#E495A5', '#55B8D0'), border = 'white')
}

}
\references{
Mariani, F., Polinesi, G., Recchioni, M. C. (2022). A tail-revisited Markowitz mean-variance approach and a portfolio network centrality. Computational Management Science, 19(3), 425-455.

Mariani, F., Ciommi, M., Chelli, F. M., Recchioni, M. C. (2020). An iterative approach to stratification: Poverty at regional level in Italy. Social Indicators Research, 1-31.
}
