% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-UserCommonFunctions.R
\name{sens.control}
\alias{sens.control}
\title{Returns Control Parameters To Find Maximum of The Sensitivity (Derivative) Function Over The Design Space}
\usage{
sens.control(
  x0 = NULL,
  optslist = list(stopval = -Inf, algorithm = "NLOPT_GN_DIRECT_L", xtol_rel = 1e-08,
    ftol_rel = 1e-08, maxeval = 1000),
  ...
)
}
\arguments{
\item{x0}{Vector of starting values for maximizing the sensitivity (derivative) function over the design space \eqn{x}.
It will be passed to the optimization function \code{\link[nloptr]{nloptr}}.}

\item{optslist}{A list. It will be passed to the argument \code{opts}  of the function \code{\link[nloptr]{nloptr}} to find the maximum of the sensitivity function over the design space. See 'Details'.}

\item{...}{Further arguments will be passed to \code{\link[nloptr:nl.opts]{nl.opts}}.}
}
\value{
A list containing \code{x0} (starting values or NULL) and \code{optslist} (control parameters for \code{\link[nloptr]{nloptr}}).
}
\description{
It returns  some arguments of the \code{\link[nloptr]{nloptr}} function including the list of control parameters.
This function is used to find the maximum of the sensitivity (derivative) function over the design space in order to
 calculate the efficiency lower bound (ELB).
}
\details{
ELB is a measure of  proximity of a design to the optimal design without knowing the latter.
Given a design, let \eqn{\epsilon} be the global maximum
 of the sensitivity (derivative) function with respect the vector of the model predictors \eqn{x} over the design space.
ELB is given by \deqn{ELB = p/(p + \epsilon),}
where \eqn{p} is the number of model parameters. Obviously,
calculating ELB requires finding \eqn{\epsilon} and therefore,
a maximization problem to be solved. The function \code{\link[nloptr]{nloptr}}
is used here to solve this maximization problem. The arguments \code{x0} and \code{optslist}
will be passed to this function as follows:

Argument \code{x0} provides the user initial values for this maximization problem
 and will be passed to the argument with the same name
in the function  \code{\link[nloptr]{nloptr}}.


Argument \code{optslist} will be passed to the argument \code{opts} of the function \code{\link[nloptr]{nloptr}}.
\code{optslist} is a \code{list} and the most important components are listed as follows:
 \describe{
  \item{\code{stopval}}{Stop minimization when an objective value <= \code{stopval} is found. Setting \code{stopval} to \code{-Inf} disables this stopping criterion (default).}
  \item{\code{algorithm}}{Defaults to \code{NLOPT_GN_DIRECT_L}. DIRECT-L is a deterministic-search algorithm based on systematic division of the search domain into smaller and smaller hyperrectangles.}
  \item{\code{xtol_rel}}{Stop when an optimization step (or an estimate of the optimum) changes every parameter by less than \code{xtol_rel} multiplied by the absolute value of the parameter. Criterion is disabled if \code{xtol_rel} is non-positive.}
  \item{\code{ftol_rel}}{Stop when an optimization step (or an estimate of the optimum) changes the objective function value by less than \code{ftol_rel} multiplied by the absolute value of the function value. Criterion is disabled if \code{ftol_rel} is non-positive. }
  \item{\code{maxeval}}{Stop when the number of function evaluations exceeds \code{maxeval}. Criterion is disabled if \code{maxeval} is non-positive.}
}
 For more details, see \code{?nloptr::nloptr.print.options}.
}
\note{
ELB must be \code{0 <=ELB <= 1}.
When the computed ELB is larger than one (equivalently \eqn{\epsilon} is negative), it may be a signal that the obtained \eqn{\epsilon} is not the global maximum.
 To overcome this issue, please increase
 the value of the parameter \code{maxeval} to allow the
  optimization algorithm to find the global maximum
  of the sensitivity (derivative) function over the design space.
}
\examples{

sens.control()
sens.control(optslist = list(maxeval = 1000))
}
