% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_coverage.R
\name{plot_coverage}
\alias{plot_coverage}
\title{Peptide coverage}
\usage{
plot_coverage(
  dat,
  protein = dat[["Protein"]][1],
  states = NULL,
  show_blanks = TRUE,
  interactive = getOption("hadex_use_interactive_plots")
)
}
\arguments{
\item{dat}{data imported by the \code{\link{read_hdx}} function}

\item{protein}{selected protein}

\item{states}{selected biological states for given protein}

\item{show_blanks}{\code{logical}, indicator if the non-covered
regions of the sequence are indicated in red}

\item{interactive}{\code{logical}, whether plot should have an interactive 
layer created with with ggiraph, which would add tooltips to the plot in an
interactive display (HTML/Markdown documents or shiny app)}
}
\value{
a \code{\link[ggplot2]{ggplot}} object
}
\description{
Plot the peptide coverage of the protein sequence
}
\details{
The function \code{\link{plot_coverage}} generates
sequence coverage plot based on experimental data for 
selected protein in selected biological states. Only non-duplicated 
peptides are shown on the plot, next to each other. 

The aim of this plot is to see the dependence between 
position of the peptide on the protein sequence. Their position
on y-axis does not contain any information.
}
\examples{
plot_coverage(alpha_dat)
plot_coverage(alpha_dat, show_blanks = FALSE)

diff_uptake_dat <- create_diff_uptake_dataset(alpha_dat)
plot_coverage(diff_uptake_dat)
}
\seealso{
\code{\link{read_hdx}} 
\code{\link{plot_position_frequency}}
}
