% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomization_metrics.R
\name{compute_randomization_metrics}
\alias{compute_randomization_metrics}
\title{Computes Randomization Metrics (explained in paper) about a design algorithm}
\usage{
compute_randomization_metrics(designs)
}
\arguments{
\item{designs}{A matrix where each column is one design.}
}
\value{
A list of resulting data: the probability estimates for
					each pair in the design of randomness where estmates close
					to ~0.5 represent random assignment, then the entropy metric
					the distance metric, the maximum eigenvalue of the allocation
					var-cov matrix (operator norm) and the squared Frobenius norm 
					(the sum of the squared eigenvalues)
}
\description{
Computes Randomization Metrics (explained in paper) about a design algorithm
}
\examples{
\dontrun{
designs = matrix(c(1, 0, 1, 0, 0, 1, 0, 1), nrow = 4, ncol = 2)
compute_randomization_metrics(designs)
}
}
\author{
Adam Kapelner
}
