% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CCA.R
\name{CCA}
\alias{CCA}
\title{Canonical Correlation Estimation}
\usage{
CCA(
  y,
  rmax = 8,
  r0 = NULL,
  r = NULL,
  localfactor = FALSE,
  method = "CCD",
  type = "IC3"
)
}
\arguments{
\item{y}{A list of the observation data, each element is a data matrix of each group with dimension \eqn{T \times N_m}.}

\item{rmax}{The maximum factor numbers of all groups. Default is 8.}

\item{r0}{The number of global factors. Default is \code{NULL}, the algorithm will automatically estimate the number of global factors.
If you have prior information about the true number of global factors, you can set it manually.}

\item{r}{The number of local factors in each group. Default is \code{NULL}, the algorithm will automatically estimate the number of local factors.
If you have prior information, set it manually as an integer vector of length \eqn{M} (the number of groups).}

\item{localfactor}{Logical. If \code{FALSE} (default), local factors are not estimated. If \code{TRUE}, local factors will be estimated.}

\item{method}{The method used in the algorithm. Default is \code{"CCD"}, can also be \code{"MCC"}.}

\item{type}{The method used in estimating the factor numbers in each group initially. Default is \code{"IC3"}.}
}
\value{
An object of class \code{"GFA"} containing:
\item{r0hat}{The estimated number of global factors.}
\item{rhat}{The estimated number of local factors (if \code{localfactor = TRUE}).}
\item{rho}{The vector of average canonical correlations (eigenvalues).}
\item{Ghat}{The estimated global factors.}
\item{Fhat}{The estimated local factors (if \code{localfactor = TRUE}).}
\item{loading_G}{A list consisting of the estimated global factor loadings.}
\item{loading_F}{A list consisting of the estimated local factor loadings (if \code{localfactor = TRUE}).}
\item{residual}{A list consisting of the residuals (if \code{localfactor = TRUE}).}
\item{threshold}{The threshold used in determining the number of global factors (only for \code{method = "MCC"}).}
}
\description{
Canonical Correlation Estimation for Group Factor Model.
}
\examples{
dat <- GrFA::gendata()
CCA(dat$y, rmax = 8, localfactor = TRUE, method = "CCD")
CCA(dat$y, rmax = 8, localfactor = TRUE, method = "MCC")

}
\references{
Choi, I., Lin, R., & Shin, Y. (2021). Canonical correlation-based model selection for the multilevel factors. Journal of Econometrics.
}
