% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2026-01-21_s4_class_methods.R
\name{galaxy_download_result}
\alias{galaxy_download_result}
\alias{galaxy_download_result,character-method}
\alias{galaxy_download_result,Galaxy-method}
\title{Generic for downloading files from a history}
\usage{
galaxy_download_result(
  x,
  out_dir = ".",
  galaxy_url = "https://usegalaxy.eu",
  overwrite = FALSE
)

\S4method{galaxy_download_result}{character}(
  x,
  out_dir = ".",
  galaxy_url = "https://usegalaxy.eu",
  overwrite = FALSE
)

\S4method{galaxy_download_result}{Galaxy}(x, out_dir = ".", overwrite = FALSE)
}
\arguments{
\item{x}{A vector of HDA output IDs (\code{character}), or a \code{Galaxy} object.}

\item{out_dir}{Directory in which to save the downloaded files.}

\item{galaxy_url}{Base URL of the Galaxy instance, used by the character
method.}

\item{overwrite}{Logical; if \code{FALSE} (default), do not overwrite existing
files but choose unique names instead.}
}
\value{
For the character method, a list of \code{httr} responses; for the
\code{Galaxy} method, the (unchanged) \code{Galaxy} object invisibly.
}
\description{
\code{galaxy_download_result()} is an S4 generic. With \code{x} as a character vector
of HDA output IDs, all corresponding datasets are downloaded into \code{out_dir}
using their Galaxy names; duplicate names are disambiguated by appending
\verb{_<i>} before the extension. Existing files are not overwritten if
\code{overwrite = FALSE}, and a warning is issued when a name is adjusted.
With \code{x} as a \code{Galaxy} object its \code{output_dataset_ids} and \code{galaxy_url}
are used; the object is returned invisibly after performing the downloads.
}
