

param_SEM <-
  function(x,k,iter=10, burn_in= 3){
    n <- N <- nrow(x) 
    P <- ncol(x)
    x <-  data.frame(x)
    K <- k
    X <- x
    kmeans_init <- suppressWarnings(kmeans(x,k,iter.max = 1))
    
    pi <- kmeans_init$size/sum(kmeans_init$size)
    mu <- kmeans_init$centers
    
    rownames(x) <- NULL
    X_cluster <- split(x, kmeans_init$cluster) 
    sigma <- array(0, dim = c(P,P,k))
    
    
    for (i in 1:K) {
      X_centered <- sweep(X_cluster[[i]], 2, mu[i,])
      X_centered <- as.matrix(X_centered) 
      sigma[ , ,i] <- (t(X_centered) %*% X_centered) / nrow(X_cluster[[i]])
      
    }
    
    
    ll <- rep(NA,iter - burn_in)
    pi_iter  <-  vector("list", iter - burn_in)
    mu_iter   <-  vector("list", iter - burn_in)
    sigma_iter <- vector("list", iter - burn_in)
    count = 0
    
    repeat{ 
      count <- count +1
      
      if (count > burn_in) {
        
        ll[count - burn_in] <- loglik(x = X , pi = pi, mu = mu , sigma =sigma)
        pi_iter[[count - burn_in]] <- pi
        mu_iter[[count - burn_in]]  <- mu
        sigma_iter[[count - burn_in]]  <- sigma
        
      }
      
      
      tau <- E.step(x = X , pi = pi, mu = mu , sigma =sigma)
      S <- rep(NA, N)
      
      for ( i in 1:N) {
        S[i] <- sample(1:K, 1, replace = FALSE, prob = tau[i,])
      }
      
      param <- M.step_sem(x = X, s = S )
      
      pi = param[[1]]
      
      mu  = param[[2]]
      sigma= param[[3]] 
      
      
      
      
      if ( count == iter){
        
        break
      } 
      
      
    }
    
    
    
    
    index <- which.max(ll)
    return(list(
      pi_k = pi_iter[[index]],
      mu    = mu_iter[[index]],
      sigma = sigma_iter[[index]]
    ))
  }
  
