% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GBOP2_minSS_TE.gbop2.R
\name{GBOP2_minSS_TE}
\alias{GBOP2_minSS_TE}
\title{PSOGO: Optimal/Minimax design with efficacy and toxicity boundaries}
\usage{
GBOP2_minSS_TE(
  design = "optimal",
  unified.u = 1,
  nlooks = 1,
  skip_efficacy = NULL,
  skip_toxicity = NULL,
  maxPatients = 26,
  Nmin_cohort1 = 13,
  Nmin_increase = 13,
  p01 = 0.3,
  p02 = 0.4,
  p03 = 0.2,
  p11 = 0.6,
  p12 = 0.2,
  p13 = 0.15,
  err_eff = 0.1,
  err_tox = 0.1,
  err_all = 0.05,
  power_all = 0.8,
  pso_method = "all",
  nParallel = 3,
  seed = 1324,
  nSwarm = 32,
  maxIter = 100
)
}
\arguments{
\item{design}{choose from "optimal", "minimax", or "unified"}

\item{unified.u}{specify when design = "unified", u in zero to one}

\item{nlooks}{number of interim looks}

\item{skip_efficacy}{default is NULL, indicate skip efficacy as 1 and not skip as 0 in a vector}

\item{skip_toxicity}{default is NULL, indicate skip toxicity as 1 and not skip as 0 in a vector}

\item{maxPatients}{maximum number of patients}

\item{Nmin_cohort1}{minimum number of first cohort}

\item{Nmin_increase}{minimum number of increase in each cohort}

\item{p01}{H0 for efficacy}

\item{p02}{H0 for toxicity}

\item{p03}{H0 for Eff and Tox}

\item{p11}{H1 for efficacy}

\item{p12}{H1 for toxicity}

\item{p13}{H1 for Eff and Tox}

\item{err_eff}{Type I error rate: Efficacious but toxic}

\item{err_tox}{Type I error rate: Safe but futile}

\item{err_all}{Type I error rate: Futile and toxic}

\item{power_all}{power: Futile and toxic}

\item{pso_method}{"all" for using three distinct pso, otherwise indicate single pso method}

\item{nParallel}{number of pso ensemble}

\item{seed}{Random seed for reproducibility}

\item{nSwarm}{nSwarm in PSO}

\item{maxIter}{maxIter in PSO}
}
\value{
A list on design parameters and operating characteristics
}
\description{
This function implements PSOGO to find an optimal or minimax design with efficacy and toxicity boundaries.
}
\details{
Parallel computing is only used when the user explicitly sets nCore > 1. No more than 2 cores should be used
unless the user is aware and permits it. The function defaults to sequential execution. If multiple analyses
are planned, consider using `init_cluster(nCore)` and `stop_cluster()` manually to control the backend.
}
\examples{
\donttest{
# init_cluster(2)
#  GBOP2_minSS_TE(
#   design = "optimal", 
#    unified.u = 1, 
#    nlooks = 1, 
#    skip_efficacy = NULL, 
#    skip_toxicity = NULL, 
#    maxPatients = 25, 
#    Nmin_cohort1 = 10, 
#    Nmin_increase = 5, 
#    p01 = 0.3, 
#    p02 = 0.4, 
#    p03 = 0.2, 
#    p11 = 0.6, 
#    p12 = 0.2, 
#    p13 = 0.15, 
#    err_eff = 0.1, 
#    err_tox = 0.1, 
#    err_all = 0.05, 
#    power_all = 0.8, 
#    pso_method = "default", 
#    nParallel = 3, 
#    seed = 5321, 
#    nSwarm = 64, 
#    maxIter = 100
#  )
# stop_cluster()  # Only if init_cluster() was used
#  
message("Run GBOP2_minSS_singleE() manually for real optimization.")
}


}
