% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{get_metrics}
\alias{get_metrics}
\title{Evaluate change point detection accuracy metrics}
\usage{
get_metrics(n, num_cps, est_cps, accept_radius)
}
\arguments{
\item{n}{Integer; total series length.}

\item{num_cps}{Integer; true number of change points.}

\item{est_cps}{Numeric vector of estimated change point locations.}

\item{accept_radius}{Numeric; tolerance radius within which an estimated
change point is considered correctly detected (a true positive).}
}
\value{
A list containing:
\itemize{
  \item `bias` — Absolute difference between true and estimated number of change points.
  \item `precision` — Proportion of correctly detected change points among all detections.
  \item `recall` — Proportion of true change points correctly detected.
  \item `F1` — Harmonic mean of precision and recall.
}
}
\description{
Computes standard evaluation metrics — bias, precision, recall, and F1-score —
for change point detection results by comparing estimated change points
against true ones within a specified tolerance (acceptance radius).
}
\details{
True change points are assumed to occur at evenly spaced positions. An
estimated change point is counted as a true positive if it lies within
\code{accept_radius} of any true change point location. Estimated points
that do not match any true change point are classified as false positives,
while true change points that are not detected are counted as false
negatives. Bias is defined as the absolute difference between the true and
estimated numbers of change points.

The metrics are defined as:
\deqn{
\text{Precision} = \frac{TP}{TP + FP}, \quad
\text{Recall} = \frac{TP}{TP + FN}, \quad
F_1 = \frac{2 \cdot \text{Precision} \cdot \text{Recall}}{\text{Precision} + \text{Recall}}.
}
}
