% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getcds.R
\name{analyzeCDNames}
\alias{analyzeCDNames}
\title{Analyze Chemical Descriptors Names}
\usage{
analyzeCDNames(df, descriptors = rcdk::get.desc.names(type = "all"))
}
\arguments{
\item{df}{dataframe with two mandatory columns: "NAME" and "SMILES"}

\item{descriptors}{Vector of chemical descriptor names}
}
\value{
A dataframe with two columns \code{descriptor} and \code{all_na}. Column \code{descriptor}
contains the names of the chemical descriptors. Column \code{all_na} contains a
boolean value indicating if all values obtained for the corresponding
descriptor are NA.
}
\description{
Analyze the chemical descriptor names and return a dataframe with their names
and a boolean column indicating if all values are NA.
}
\details{
This function is used to analyze the chemical descriptor names and to
identify which descriptors produce only NAs in the test datasets. The
function is used to generate the CDNames object.
}
\examples{
X <- analyzeCDNames(df = head(RP, 2), descriptors = CDNames[1:2])

}
\keyword{internal}
