% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{prep_data}
\alias{prep_data}
\title{Data preprocessing for FIRM integration}
\usage{
prep_data(counts, hvg_genes = 4000)
}
\arguments{
\item{counts}{Raw count matrix (genes × cells) or \code{dgCMatrix}.}

\item{hvg_genes}{Target number of genes to return (default 4 000).}
}
\value{
A named list with elements
         \describe{
           \item{Dataset}{Seurat object after normalization, scaling and
                          feature selection.}
           \item{hvg}{Character vector of the 4 000 most variable genes.}
         }
}
\description{
Performs a standard Seurat workflow: normalization, scaling and
selection of the top 4 000 highly-variable genes (HVGs).
}
\examples{
\donttest{
set.seed(42)
library(Seurat)
library(FIRM)
data("ExampleData")
prep_SS2  <- prep_data(ExampleData$SS2, hvg_genes = 1000)
Dataset1  <- prep_SS2$Dataset
hvg1      <- prep_SS2$hvg

prep_tenx <- prep_data(ExampleData$tenx, hvg_genes = 1000)
Dataset2  <- prep_tenx$Dataset
hvg2      <- prep_tenx$hvg
}

}
\seealso{
\code{\link{FIRM}} for the integration step.
}
\author{
Jingsi Ming
}
