% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict3D.R
\name{predict3D}
\alias{predict3D}
\title{Funcao para obter valores para construcao de graficos de superficie resposta}
\usage{
predict3D(Resultado, modelo=NULL, type=1,n=30)
}
\arguments{
\item{Resultado}{:Objeto do tipo list referente ao output da funcao
AjustarRegressao.}

\item{modelo}{Valor numerico indicando o modelo considerado na confeccao do
grafico. Pode ser
NULL (default) ou um valor numerico indicando o modelo a ser considerado.
\itemize{
\item NULL -> Considera o melhor dos  modelos testados de acordo com o
Criterio de informatividade de Akaike (AIC)
\item n -> considera o n-esimo modelo para plotar o grafico.

}}

\item{type}{:Valor de 1 a 3 indicando o output desejado pela funcao.
 \itemize{
\item 1: Matriz XYZ
\item 2: Matriz Z quadrada
\item 3: Matriz XY + Z quadrada
 }}

\item{n}{:Numeros de valores equidistantes entre o menor e maior valor de
cada variavel explicativa. O numero final de valores preditos sera n x n.}
}
\value{
A funcao apresenta  valores para a obtencao de grafico de superificie
 resposta 3D.
}
\description{
Esta funcao possibilita gerar valores para construcao de
graficos de superficie resposta (3D).
}
\examples{
 ############################################################################
 ############################################################################
 #Exemplo 1: Experimento sem delineamento
 data("Dados1")
 res=AjustarRegressao(Dados = Dados1, design=1)
 predict3D(Resultado = res,type =1) #matriz XYZ
 predict3D(Resultado = res,type =2) #matriz Z quadrada
 predict3D(Resultado = res,type =3) #matriz XY + Z quadrada


 ############################################################################
 ############################################################################
 #Exemplo 2: Experimento sem delineamento
 data("Dados2")
 res=AjustarRegressao(Dados = Dados2, design=1)
 predict3D(Resultado = res,type =1) #matriz XYZ
 predict3D(Resultado = res,type =2) #matriz Z quadrada
 predict3D(Resultado = res,type =3) #matriz XY + Z quadrada

 ############################################################################
 ############################################################################
 #Exemplo 3: Experimento com delineamento (DIC)
 data("Dados3")
 res=AjustarRegressao(Dados = Dados3, design=2)
 predict3D(Resultado = res,type =1) #matriz XYZ
 predict3D(Resultado = res,type =2) #matriz Z quadrada
 predict3D(Resultado = res,type =3) #matriz XY + Z quadrada

 ############################################################################
 ############################################################################
 #Exemplo 4: Experimento com delineamento (DBC)
 data("Dados3")
 res=AjustarRegressao(Dados = Dados3, design=3)
 predict3D(Resultado = res,type =1) #matriz XYZ
 predict3D(Resultado = res,type =2) #matriz Z quadrada
 predict3D(Resultado = res,type =3) #matriz XY + Z quadrada
}
\seealso{
\code{\link{plot2D}}, \code{\link{plot3D}},
 \code{\link{AjustarRegressao}}
}
