% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{forecast_opts}
\alias{forecast_opts}
\title{Forecast options}
\usage{
forecast_opts(horizon = 7, accumulate)
}
\arguments{
\item{horizon}{Numeric, defaults to 7. Number of days into the future to
forecast.}

\item{accumulate}{Integer, the number of days to accumulate in forecasts, if
any. If not given and observations are accumulated at constant frequency in
the data used for fitting then the same accumulation will be used in
forecasts unless set explicitly here.}
}
\value{
A \verb{<forecast_opts>} object of forecast setting.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Defines a list specifying the arguments passed to underlying stan
backend functions via \code{\link[=stan_sampling_opts]{stan_sampling_opts()}} and \code{\link[=stan_vb_opts]{stan_vb_opts()}}. Custom
settings can be supplied which override the defaults.
}
\examples{
forecast_opts(horizon = 28, accumulate = 7)
}
\seealso{
\code{\link[=fill_missing]{fill_missing()}}
}
