## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(EZbakR)

## -----------------------------------------------------------------------------
simdata <- EZSimulate(nfeatures = 300, nreps = 2)

# Make initial EZbakRData object
ezbdo <- EZbakRData(simdata$cB, simdata$metadf)

# Estimate fractions twice, and don't overwrite the first analysis
# Second run will use different model; see EstimateFractions vignette for details
ezbdo <- EstimateFractions(ezbdo)
ezbdo <- EstimateFractions(ezbdo, strategy = 'hierarchical', overwrite = FALSE)

# Estimate kinetic parameters with three different strategies
# See EstimateKinetics vignettes for details.
ezbdo <- EstimateKinetics(ezbdo, repeatID = 1)
ezbdo <- EstimateKinetics(ezbdo, repeatID = 1, strategy = "shortfeed")
ezbdo <- EstimateKinetics(ezbdo, repeatID = 2, strategy = "shortfeed")

## -----------------------------------------------------------------------------
# `$` notation:
ezbdo$fractions$feature

# `[[]]` notation with element names
ezbdo[['fractions']][['feature']]

# `[[]]` notation with numeric indices
ezbdo[[4]][[1]]


## -----------------------------------------------------------------------------
kinetics <- EZget(ezbdo,
                  type = "kinetics",
                  kstrat = "standard")

## -----------------------------------------------------------------------------
h_fxn <- EZget(ezbdo, 
               type = 'fractions',
               repeatID = 2)

