% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQRN.R
\name{EQRN_predict_internal}
\alias{EQRN_predict_internal}
\title{Internal predict function for an EQRN_iid}
\usage{
EQRN_predict_internal(
  fit_eqrn,
  X,
  prob_lvl_predict,
  intermediate_quantiles,
  interm_lvl,
  device = default_device()
)
}
\arguments{
\item{fit_eqrn}{Fitted \code{"EQRN_iid"} object.}

\item{X}{Matrix of covariates to predict the corresponding response's conditional quantiles.}

\item{prob_lvl_predict}{Probability level at which to predict the conditional quantiles.}

\item{intermediate_quantiles}{Vector of intermediate conditional quantiles at level \code{fit_eqrn$interm_lvl}.}

\item{interm_lvl}{Optional, checks that \code{interm_lvl == fit_eqrn$interm_lvl}.}

\item{device}{(optional) A \code{\link[torch:torch_device]{torch::torch_device()}}. Defaults to \code{\link[=default_device]{default_device()}}.}
}
\value{
Vector of length \code{nrow(X)} containing the conditional quantile estimates of the response associated to each covariate observation
at each probability level \code{prob_lvl_predict}.
}
\description{
Internal predict function for an EQRN_iid
}
\keyword{internal}
