% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{load.scaler}
\alias{load.scaler}
\title{Load the Scaler for the pre-trained Neural Networks for Determining the Number of Factors}
\usage{
load.scaler(model = "DNN")
}
\arguments{
\item{model}{A character string indicating the model type. Possible values are \code{"DNN"} (default) or \code{"LSTM"}.}
}
\value{
scaler objective.
}
\description{
Loads the scaler object within the \code{EFAfactors} package. This object is a \code{list} containing a mean vector and
a standard deviation vector, which were computed from the 10,000,000 datasets \code{\link[EFAfactors]{data.datasets.DNN}}
training the Deep Neural Network (DNN) or the 1,000,000 datasets \code{\link[EFAfactors]{data.datasets.LSTM}}
training the Long Short Term Memory (LSTM) Network. It serves as a tool for normalizing features in
\code{\link[EFAfactors]{NN}}.
}
\examples{
library(EFAfactors)

scaler <- load.scaler()
print(scaler)


}
\seealso{
\code{\link[EFAfactors]{NN}}, \code{\link[EFAfactors]{normalizor}},
\code{\link[EFAfactors]{data.scaler.DNN}}, \code{\link[EFAfactors]{data.scaler.LSTM}}
}
