% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_inventory.R
\name{plot_inventory}
\alias{plot_inventory}
\title{Function to plot the inventory results into a lidR 3d plot of the point cloud}
\usage{
plot_inventory(plot, inventory, col = NA, cex = 1.5, label_col = "white")
}
\arguments{
\item{plot}{lidR 3d plot}

\item{inventory}{data.frame with the inventory results}

\item{col}{color of the spheres}

\item{cex}{numeric size of the labels}

\item{label_col}{character color of the labels}
}
\value{
the plot with the inventory results
}
\description{
Function to plot the inventory results into a lidR 3d plot of the point cloud
}
\examples{
\donttest{
# read example data
file = system.file("extdata", "beech.las", package="CspStandSegmentation")
las = lidR::readTLSLAS(file)

# find tree positions as starting points for segmentation
map <- CspStandSegmentation::find_base_coordinates_raster(las)

# segment trees
segmented <- las |>
  CspStandSegmentation::add_geometry(n_cores = 2) |>
  CspStandSegmentation::csp_cost_segmentation(map, 1, N_cores = 2)

# perform inventory
inventory <- CspStandSegmentation::forest_inventory(segmented, n_cores = 2)

# plot the results
\dontrun{
x <- lidR::plot(segmented, color = "TreeID")
plot_inventory(x, inventory)
}
}

}
