% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotScm.R
\name{plotScm}
\alias{plotScm}
\title{plotScm}
\usage{
plotScm(
  scm,
  runName = "",
  saveRes = FALSE,
  saveDir = NULL,
  rowOrder = FALSE,
  colOrder = TRUE
)
}
\arguments{
\item{scm}{Sample by component matrix}

\item{runName}{Name of the run used in plot titles, Default is ""}

\item{saveRes}{Whether or not to save the plots, Default is FALSE}

\item{saveDir}{Where to save the plots, must be provided if using saveDir}

\item{rowOrder}{Ordering specification for the rows of the heatmap. Three possible options:
* TRUE:  Uses hierarchical clustering to determine row order.
* FALSE: (default) Leaves rows in the order they were given.
* A numeric vector the same length as the number of rows specifying the indices of the input matrix}

\item{colOrder}{Ordering specification for the columns of the heatmap. See above for options. Default value is T.}
}
\value{
pheatmap figure of component result by sample
}
\description{
This function is used to generate the sample by component matrix plot.
}
\examples{
plotScm(scmExp)

plotScm(scmExp, rowOrder = FALSE, colOrder = FALSE)

newOrder = sample(1:ncol(scmExp), ncol(scmExp))
plotScm(scmExp, colOrder = newOrder)
}
\keyword{matrix}
\keyword{plot}
\keyword{scm}
