#' plotSigs
#'
#' This function plots all of the signatures so that they can be visualized.
#' It does this by looping through the signatures and calling the plotSig
#' function
#'
#' @param sigs The dataset of component contribution to each signature
#' @param saveRes Whether or not to save results. Default is FALSE.
#' @param saveDir Where to save plots, must be provided if using saveDir
#' @param runName Used to add a runName to the file output. Default is "".
#' @keywords signatures plot
#' @export
#' @return Plots all the signatures to allow visualization
#' @examples 
#' plotSigs(referenceExp$sigs)
plotSigs = function(sigs, saveRes=FALSE,saveDir=NULL,runName = ""){
  for (i in 1:ncol(sigs)){
    if (saveRes) {
      if (is.null(saveDir)){
	stop('No saveDir provided for saveRes. Please set saveDir.')
      }
      grDevices::tiff(paste0(saveDir,"/",runName,"_Signature",i,".tiff"),
                      width = 4, height = 3, units = 'in', res = 300)
      print(plotSig(sigs,i))
      grDevices::dev.off()
    }
    else {
      print(plotSig(sigs,i))
    }
  }
}
