\name{CICI-package}
\alias{CICI}
\docType{package}
\title{
Causal Inference with Continuous (Multiple Time Point) Interventions
}
\description{
This package facilitates the estimation of counterfactual outcomes for multiple values of continuous interventions at different time points, and allows plotting of causal dose-response curves. 

It offers implementations of both the (semi-)parametric \emph{g}-formula and the sequential \emph{g}-computation formula. Positivity violations can be detected with diagnostics, and addressed either through \emph{feasible} intervention strategies, or outcome weights. Details are given in Schomaker et al. (2025) and Bao and Schomaker (2025), see references below. 

}

\details{
\tabular{ll}{
Package: \tab CICI\cr
Type: \tab Package\cr
Version: \tab 0.9.8\cr
Date: \tab 2025-12-19\cr
License: \tab GPL-2\cr
Depends: \tab R (>= 4.0)\cr
Imports: \tab mgcv, glmnet, ggplot2, parallel, doParallel, foreach, doRNG, rngtools, SuperLearner, survival\cr
Suggests: \tab haldensify, hal9001 \cr
}

}
\author{
Michael Schomaker

Maintainer: Michael Schomaker <michael.schomaker@stat.uni-muenchen.de>
}

\references{
Schomaker M, McIlleron H, Denti P, Diaz I. (2024) \emph{Causal Inference for Continuous Multiple Time Point Interventions}, Statistics in Medicine, 43:5380-5400, see also \emph{https://arxiv.org/abs/2305.06645}.

Bao H, Schomaker M (2025) \emph{Addressing Positivity Violations in Continuous Interventions through Data-Adaptive Strategies}, arXiv ePrint, \emph{https://arxiv.org/abs/2502.14566}.
}
