% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_rrect.R
\name{geom_rrect}
\alias{geom_rrect}
\title{geom_rrect}
\usage{
geom_rrect(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  r = 0.2,
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2]{aes}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{A data.frame, or other object, will override the plot data. All objects will be
fortified to produce a data frame.}

\item{stat}{Name of stat to modify data.}

\item{position}{The position adjustment to use for overlapping points on this layer.}

\item{r}{The radius of rounded corners.}

\item{...}{additional parameter, e.g. color, linewidth, alpha.}

\item{na.rm}{If "FALSE" (default), missing values are removed with a warning. If "TRUE", missing values are silently removed, logical.}

\item{show.legend}{Whether to show legend, logical.}

\item{inherit.aes}{Whether to inherit aesthetic mappings, logical, defaults to "TRUE".}
}
\value{
ggplot object
}
\description{
Rounded rectangle
}
\details{
draws rounded rectangle by using the locations
of the four corners (xmin, xmax, ymin and ymax) like geom_rect().
}
\section{Aesthetics}{

\code{geom_rrect()} understands the following aesthetics (required aesthetics are in bold):
\itemize{
\item \strong{\code{\link[ggplot2]{xmin}}}
\item \strong{\code{\link[ggplot2]{xmax}}}
\item \strong{\code{\link[ggplot2]{ymin}}}
\item \strong{\code{\link[ggplot2]{ymax}}}
\item \code{\link[ggplot2]{alpha}}
\item \code{\link[ggplot2]{colour}}
\item \code{\link[ggplot2]{fill}}
\item \code{\link[ggplot2]{group}}
\item \code{\link[ggplot2]{linetype}}
}
Learn more about setting these aesthetics in \code{vignette("ggplot2-specs")}.
}

\examples{
library(ggplot2)
df <- data.frame(
 xmin = c(1, 2, 3),
 xmax = c(2, 3, 4),
 ymin = c(1, 2, 3),
 ymax = c(2, 3, 4),
 category = c("A", "B", "C")
 )
 
 p <- ggplot(df) +
   geom_rrect(aes(xmin = xmin, xmax = xmax, 
              ymin = ymin, ymax = ymax, fill = category), 
             r = 0.4, linewidth = 1, colour = "black") 
 
 print(p)

}
\author{
Shiqi Zhao
}
