% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdReduce_hdf5_dataset}
\alias{bdReduce_hdf5_dataset}
\title{Reduce Multiple HDF5 Datasets}
\usage{
bdReduce_hdf5_dataset(
  filename,
  group,
  reducefunction,
  outgroup = NULL,
  outdataset = NULL,
  overwrite = FALSE,
  remove = FALSE
)
}
\arguments{
\item{filename}{Character string. Path to the HDF5 file.}

\item{group}{Character string. Path to the group containing datasets.}

\item{reducefunction}{Character. Operation to apply, either "+" or "-".}

\item{outgroup}{Character string (optional). Output group path. If NULL,
uses input group.}

\item{outdataset}{Character string (optional). Output dataset name. If NULL,
uses input group name.}

\item{overwrite}{Logical (optional). Whether to overwrite existing dataset.
Default is FALSE.}

\item{remove}{Logical (optional). Whether to remove source datasets after
reduction. Default is FALSE.}
}
\value{
List with components. If an error occurs, all string values are returned as empty strings (""):
\describe{
\item{fn}{Character string with the HDF5 filename}
\item{ds}{Character string with the full dataset path to the reduced dataset (group/dataset)}
\item{func}{Character string with the reduction function applied}
}
}
\description{
Reduces multiple datasets within an HDF5 group using arithmetic operations
(addition or subtraction).
}
\details{
This function provides efficient dataset reduction capabilities with:
\itemize{
\item Operation options:
\itemize{
\item Addition of datasets
\item Subtraction of datasets
}
\item Output options:
\itemize{
\item Custom output location
\item Configurable dataset name
\item Overwrite protection
}
\item Implementation features:
\itemize{
\item Memory-efficient processing
\item Safe file operations
\item Optional source cleanup
\item Comprehensive error handling
}
}

The function processes datasets efficiently while maintaining data integrity.
}
\examples{
\dontrun{
library(BigDataStatMeth)

# Create test matrices
X1 <- matrix(1:100, 10, 10)
X2 <- matrix(101:200, 10, 10)
X3 <- matrix(201:300, 10, 10)

# Save to HDF5
fn <- "test.hdf5"
bdCreate_hdf5_matrix(fn, X1, "data", "matrix1",
                     overwriteFile = TRUE)
bdCreate_hdf5_matrix(fn, X2, "data", "matrix2",
                     overwriteFile = FALSE)
bdCreate_hdf5_matrix(fn, X3, "data", "matrix3",
                     overwriteFile = FALSE)

# Reduce datasets by addition
bdReduce_hdf5_dataset(
  filename = fn,
  group = "data",
  reducefunction = "+",
  outgroup = "results",
  outdataset = "sum_matrix",
  overwrite = TRUE
)

# Cleanup
if (file.exists(fn)) {
  file.remove(fn)
}
}

}
\references{
\itemize{
\item The HDF Group. (2000-2010). HDF5 User's Guide.
}
}
\seealso{
\itemize{
\item \code{\link{bdCreate_hdf5_matrix}} for creating HDF5 matrices
}
}
