% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdDiag_add_hdf5}
\alias{bdDiag_add_hdf5}
\title{Add Diagonal Elements from HDF5 Matrices or Vectors}
\usage{
bdDiag_add_hdf5(
  filename,
  group,
  A,
  B,
  groupB = NULL,
  target = NULL,
  outgroup = NULL,
  outdataset = NULL,
  paral = NULL,
  threads = NULL,
  overwrite = NULL
)
}
\arguments{
\item{filename}{String. Path to the HDF5 file containing the datasets.}

\item{group}{String. Group path containing the first dataset (A).}

\item{A}{String. Name of the first dataset (matrix or vector).}

\item{B}{String. Name of the second dataset (matrix or vector).}

\item{groupB}{Optional string. Group path containing dataset B.}

\item{target}{Optional string. Where to write result: "A", "B", or "new" (default: "new").}

\item{outgroup}{Optional string. Output group path (only used if target="new").}

\item{outdataset}{Optional string. Output dataset name (only used if target="new").}

\item{paral}{Optional logical. Whether to use parallel processing.}

\item{threads}{Optional integer. Number of threads for parallel processing.}

\item{overwrite}{Optional logical. Whether to overwrite existing datasets.}
}
\value{
List with components:
\describe{
\item{fn}{Character string with the HDF5 filename}
\item{ds}{Character string with the full dataset path to the diagonal addition result (group/dataset)}
}
}
\description{
Performs optimized diagonal addition between two datasets stored in HDF5 format.
Automatically detects whether inputs are matrices (extracts diagonals) or vectors
(direct operation) and uses the most efficient approach.
}
