% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_normal.R
\name{bi.dist.log_normal}
\alias{bi.dist.log_normal}
\title{Log Normal distribution}
\usage{
bi.dist.log_normal(
  loc = 0,
  scale = 1,
  validate_args = py_none(),
  name = "x",
  obs = py_none(),
  mask = py_none(),
  sample = FALSE,
  seed = py_none(),
  shape = c(),
  event = 0,
  create_obj = FALSE,
  to_jax = TRUE
)
}
\arguments{
\item{loc}{Numeric; Location parameter.}

\item{scale}{Numeric; Scale parameter.}

\item{validate_args}{Logical: Whether to validate parameter values.  Defaults to `reticulate::py_none()`.}

\item{name}{A character string representing the name of the random variable
within a model. This is used to uniquely identify the variable. Defaults to 'x'.}

\item{obs}{A numeric vector or array of observed values. If provided, the
random variable is conditioned on these values. If `NULL`, the variable is
treated as a latent (unobserved) variable. Defaults to `NULL`.}

\item{mask}{Logical vector; Optional boolean array to mask observations.}

\item{sample}{A logical value that controls the function's behavior. If `TRUE`,
the function will directly draw samples from the distribution. If `FALSE`,
it will create a random variable within a model. Defaults to `FALSE`.}

\item{seed}{An integer used to set the random seed for reproducibility when
`sample = TRUE`. This argument has no effect when `sample = FALSE`, as
randomness is handled by the model's inference engine. Defaults to 0.}

\item{shape}{Numeric vector; A multi-purpose argument for shaping. When `sample=False` (model building),
this is used with `.expand(shape)` to set the distribution's batch shape.
When `sample=True` (direct sampling), this is used as `sample_shape` to draw a raw JAX array
of the given shape.}

\item{event}{Numeric; The number of batch dimensions to reinterpret as event dimensions (used in model building).}

\item{create_obj}{Logical; If True, returns the raw BI distribution object instead of creating a sample
site. This is essential for building complex distributions like `MixtureSameFamily`.}

\item{to_jax}{Boolean. Indicates whether to return a JAX array or not.}
}
\value{
- When \code{sample=FALSE}, a BI Log Normal distribution object (for model building).

 - When \code{sample=TRUE}, a JAX array of samples drawn from the Log Normal distribution (for direct sampling).

 - When \code{create_obj=TRUE}, the raw BI distribution object (for advanced use cases).
}
\description{
The Log-Normal distribution is a probability distribution defined for positive real-valued random variables,
parameterized by a location parameter (loc: \deqn{\mu}) and a scale parameter (scale).
It arises when the logarithm of a random variable is normally distributed.
It is often used when modeling parameters that must be positive.
}
\examples{
\donttest{
library(BayesianInference)
m=importBI(platform='cpu')
bi.dist.log_normal(sample = TRUE)
}
}
\seealso{
This is a wrapper of  \url{https://num.pyro.ai/en/stable/distributions.html#lognormal}
}
