% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ces_helpers.R
\name{list_ces_industries}
\alias{list_ces_industries}
\title{List Available Industry Filters for CES Data}
\usage{
list_ces_industries(show_descriptions = FALSE)
}
\arguments{
\item{show_descriptions}{Logical. If TRUE, returns a data frame with
filter names and descriptions. If FALSE, returns just the filter names.}
}
\value{
A character vector of industry filter names, or a data frame
  with names and descriptions if show_descriptions = TRUE
}
\description{
Lists all available industry categories that can be used with the
`industry_filter` parameter in `get_ces()` function. These filters allow
you to download specific industry data instead of the complete dataset.
}
\examples{
# See all available industry filters
list_ces_industries()

# See filters with descriptions
list_ces_industries(show_descriptions = TRUE)

# Use with get_ces
# manufacturing_data <- get_ces(industry_filter = "manufacturing")  # All states
}
