% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_lineup_metrics.R
\name{do_lineup_metrics}
\alias{do_lineup_metrics}
\title{Lineups-related information}
\usage{
do_lineup_metrics(data_possess, team_sel, team_opp)
}
\arguments{
\item{data_possess}{Play-by-play data with the start of possessions.}

\item{team_sel}{One of the teams involved in the game.}

\item{team_opp}{Opponent team.}
}
\value{
Data frame. Each row is a different lineup.
}
\description{
For every lineup, compute the number of possessions, points, assists, 
turnovers, field goals, rebounds and assisted field goals, both in defense 
and offense.
}
\examples{
\dontrun{
library(dplyr)
df0 <- acb_vbc_cz_pbp_2223

day_num <- unique(acb_vbc_cz_pbp_2223$day)
game_code <- unique(acb_vbc_cz_pbp_2223$game_code)

# Starting players:
acb_games_2223_sl <- acb_vbc_cz_sl_2223 \%>\%
  dplyr::filter(period == "1C")

# Prepare data:
df1 <- do_prepare_data(df0, day_num, 
                       acb_games_2223_sl, acb_games_2223_info,
                       game_code)

teams_game <- sort(unique(df1$team))
team_sel <- teams_game[1]

data <- df1
data <- data \%>\%
  mutate(row_num = row_number()) \%>\%
  mutate(time_point = ifelse(nchar(time_point) < 5, paste0("0", time_point), time_point))

# Filter by team:
data1 <- data \%>\%
  filter(team == team_sel)

# Set also the opponent team:
team_opp <- setdiff(unique(data$team), team_sel)

# Add the last row of games' data to have the real final 
# game score in case it is not available:
last_row_game <- data[nrow(data),]

last_row_game$time_point <- "00:00"
last_row_game$player <- NA
last_row_game$action <- NA
last_row_game$team <- team_sel

data1 <- bind_rows(data1, last_row_game)

# Get players out:
pl_out <- c(1, which(data1$action == "Sale de la pista"), nrow(data1))

i <- 1
data2 <- data1 \%>\%
  slice(pl_out[i]:pl_out[i + 1]) 

nr <- nrow(data2)

# Lineup:
lineup <- data2 \%>\%
  filter(action != "Sale de la pista") \%>\%
  # Avoid actions that are assigned to teams: 
  filter(player != team_sel) \%>\%
  distinct(player) \%>\%
  pull()

# Identify when the possessions start:
data2_rival <- data \%>\%
  filter(team == team_opp) \%>\%
  filter(between(row_num, data2$row_num[1], data2$row_num[nr]))

data3 <- rbind(data2, data2_rival) \%>\%
  arrange(row_num) \%>\%
  na.omit()

data4 <- do_possession(data3, NULL, "10:00") 

data4[data4$action == "Mate", "action"] <- "Tiro de 2 anotado"

# Obtain metrics for the lineup:
data5 <- do_lineup_metrics(data4, team_sel, team_opp)
}

}
\author{
Guillermo Vinue
}
