% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_possession_stats.R
\name{do_possession_stats}
\alias{do_possession_stats}
\title{Possessions-related statistics}
\usage{
do_possession_stats(data_possess, season = "2025-2026")
}
\arguments{
\item{data_possess}{Data frame with the beginning of each possession 
obtained with \code{\link{do_possession}}.}

\item{season}{Season string.}
}
\value{
A data frame with the possessions statistics for each team.
}
\description{
Compute the possessions-related statistics, namely, offensive rating, defensive rating, 
net rating, pace and number of possessions.
}
\details{
See \url{https://www.basketball-reference.com/about/glossary.html}
for formulas and explanations.

Both teams in the same game share the same pace. Pace reflects the tempo of the game itself, 
not just one team's style.Over many games, a team's average pace reflects how fast they 
usually play, but any individual game's pace is shared with their opponent.
}
\examples{
\dontrun{
library(dplyr)
df0 <- acb_vbc_cz_pbp_2223

day_num <- unique(acb_vbc_cz_pbp_2223$day)
game_code <- unique(acb_vbc_cz_pbp_2223$game_code)

acb_games_2223_sl <- acb_vbc_cz_sl_2223 \%>\%
  filter(period == "1C")

df1 <- do_prepare_data(df0, day_num, 
                       acb_games_2223_sl, acb_games_2223_info,
                       game_code)
                       
df2 <- do_possession(df1, "1C")    

do_possession_stats(df2, "2022-2023")
}

}
\seealso{
\code{\link{do_possession}}
}
\author{
Guillermo Vinue
}
