% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossing.R
\name{randCross}
\alias{randCross}
\title{Make random crosses}
\usage{
randCross(
  pop,
  nCrosses,
  nProgeny = 1,
  balance = TRUE,
  parents = NULL,
  ignoreSexes = FALSE,
  simParam = NULL
)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}}}

\item{nCrosses}{total number of crosses to make}

\item{nProgeny}{number of progeny per cross}

\item{balance}{if using sexes, this option will balance the number
of progeny per parent}

\item{parents}{an optional vector of indices for allowable parents}

\item{ignoreSexes}{should sexes be ignored}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
Returns an object of \code{\link{Pop-class}}
}
\description{
A wrapper for \code{\link{makeCross}} that randomly
selects parental combinations for all possible combinantions.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}

#Create population
pop = newPop(founderPop, simParam=SP)

#Make 10 crosses
pop2 = randCross(pop, 10, simParam=SP)

}
