## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(semfindr)
dat <- pa_dat
# Add case id
dat <- cbind(id = paste0("case", seq_len(nrow(dat))), dat)
head(dat)

## -----------------------------------------------------------------------------
library(lavaan)
mod <-
"
iv1 ~~ iv2
m1 ~ iv1 + iv2
dv ~ m1
"
fit <- sem(mod, dat)

## -----------------------------------------------------------------------------
rerun_out <- lavaan_rerun(fit,
                          to_rerun = c(1, 4, 15, 18))

## -----------------------------------------------------------------------------
rerun_out
est_change(rerun_out)

## -----------------------------------------------------------------------------
rerun_out <- lavaan_rerun(fit,
                          case_id = dat$id,
                          to_rerun = c("case1",
                                       "case4",
                                       "case15",
                                       "case18"))

## -----------------------------------------------------------------------------
rerun_out
est_change(rerun_out)

## -----------------------------------------------------------------------------
rerun_out <- lavaan_rerun(fit,
                          case_id = dat$id,
                          resid_md_top = 5)

## -----------------------------------------------------------------------------
rerun_out
est_change(rerun_out)

## -----------------------------------------------------------------------------
rerun_out <- lavaan_rerun(fit,
                          case_id = dat$id,
                          md_top = 5)

## -----------------------------------------------------------------------------
rerun_out
est_change(rerun_out)

