/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.neural;

import java.util.Random;
import weka.classifiers.functions.neural.NeuralConnection;
import weka.classifiers.functions.neural.NeuralMethod;
import weka.core.RevisionUtils;

public class NeuralNode
extends NeuralConnection {
    private static final long serialVersionUID = -1085750607680839163L;
    private double[] m_weights = new double[1];
    private double[] m_bestWeights = new double[1];
    private double[] m_changeInWeights = new double[1];
    private Random m_random;
    private NeuralMethod m_methods;

    public NeuralNode(String id, Random r, NeuralMethod m) {
        super(id);
        this.m_random = r;
        this.m_weights[0] = this.m_random.nextDouble() * 0.1 - 0.05;
        this.m_changeInWeights[0] = 0.0;
        this.m_methods = m;
    }

    public void setMethod(NeuralMethod m) {
        this.m_methods = m;
    }

    public NeuralMethod getMethod() {
        return this.m_methods;
    }

    @Override
    public double outputValue(boolean calculate) {
        if (Double.isNaN(this.m_unitValue) && calculate) {
            this.m_unitValue = this.m_methods.outputValue(this);
        }
        return this.m_unitValue;
    }

    @Override
    public double errorValue(boolean calculate) {
        if (!Double.isNaN(this.m_unitValue) && Double.isNaN(this.m_unitError) && calculate) {
            this.m_unitError = this.m_methods.errorValue(this);
        }
        return this.m_unitError;
    }

    @Override
    public void reset() {
        if (!Double.isNaN(this.m_unitValue) || !Double.isNaN(this.m_unitError)) {
            this.m_unitValue = Double.NaN;
            this.m_unitError = Double.NaN;
            this.m_weightsUpdated = false;
            int noa = 0;
            while (noa < this.m_numInputs) {
                this.m_inputList[noa].reset();
                ++noa;
            }
        }
    }

    @Override
    public void saveWeights() {
        System.arraycopy(this.m_weights, 0, this.m_bestWeights, 0, this.m_weights.length);
        int i = 0;
        while (i < this.m_numInputs) {
            this.m_inputList[i].saveWeights();
            ++i;
        }
    }

    @Override
    public void restoreWeights() {
        System.arraycopy(this.m_bestWeights, 0, this.m_weights, 0, this.m_weights.length);
        int i = 0;
        while (i < this.m_numInputs) {
            this.m_inputList[i].restoreWeights();
            ++i;
        }
    }

    @Override
    public double weightValue(int n) {
        if (n >= this.m_numInputs || n < -1) {
            return Double.NaN;
        }
        return this.m_weights[n + 1];
    }

    public double[] getWeights() {
        return this.m_weights;
    }

    public double[] getChangeInWeights() {
        return this.m_changeInWeights;
    }

    @Override
    public void updateWeights(double l, double m) {
        if (!this.m_weightsUpdated && !Double.isNaN(this.m_unitError)) {
            this.m_methods.updateWeights(this, l, m);
            super.updateWeights(l, m);
        }
    }

    @Override
    protected boolean connectInput(NeuralConnection i, int n) {
        if (!super.connectInput(i, n)) {
            return false;
        }
        this.m_weights[this.m_numInputs] = this.m_random.nextDouble() * 0.1 - 0.05;
        this.m_changeInWeights[this.m_numInputs] = 0.0;
        return true;
    }

    @Override
    protected void allocateInputs() {
        NeuralConnection[] temp1 = new NeuralConnection[this.m_inputList.length + 15];
        int[] temp2 = new int[this.m_inputNums.length + 15];
        double[] temp4 = new double[this.m_weights.length + 15];
        double[] temp5 = new double[this.m_changeInWeights.length + 15];
        double[] temp6 = new double[this.m_bestWeights.length + 15];
        temp4[0] = this.m_weights[0];
        temp5[0] = this.m_changeInWeights[0];
        temp6[0] = this.m_bestWeights[0];
        int noa = 0;
        while (noa < this.m_numInputs) {
            temp1[noa] = this.m_inputList[noa];
            temp2[noa] = this.m_inputNums[noa];
            temp4[noa + 1] = this.m_weights[noa + 1];
            temp5[noa + 1] = this.m_changeInWeights[noa + 1];
            temp6[noa + 1] = this.m_bestWeights[noa + 1];
            ++noa;
        }
        this.m_inputList = temp1;
        this.m_inputNums = temp2;
        this.m_weights = temp4;
        this.m_changeInWeights = temp5;
        this.m_bestWeights = temp6;
    }

    @Override
    protected boolean disconnectInput(NeuralConnection i, int n) {
        int loc = -1;
        boolean removed = false;
        do {
            loc = -1;
            int noa = 0;
            while (noa < this.m_numInputs) {
                if (i == this.m_inputList[noa] && (n == -1 || n == this.m_inputNums[noa])) {
                    loc = noa;
                    break;
                }
                ++noa;
            }
            if (loc < 0) continue;
            noa = loc + 1;
            while (noa < this.m_numInputs) {
                this.m_inputList[noa - 1] = this.m_inputList[noa];
                this.m_inputNums[noa - 1] = this.m_inputNums[noa];
                this.m_weights[noa] = this.m_weights[noa + 1];
                this.m_changeInWeights[noa] = this.m_changeInWeights[noa + 1];
                this.m_inputList[noa - 1].changeOutputNum(this.m_inputNums[noa - 1], noa - 1);
                ++noa;
            }
            --this.m_numInputs;
            removed = true;
        } while (n == -1 && loc != -1);
        return removed;
    }

    @Override
    public void removeAllInputs() {
        super.removeAllInputs();
        double temp1 = this.m_weights[0];
        double temp2 = this.m_changeInWeights[0];
        this.m_weights = new double[1];
        this.m_changeInWeights = new double[1];
        this.m_weights[0] = temp1;
        this.m_changeInWeights[0] = temp2;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5403 $");
    }
}

