/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import java.time.DayOfWeek;
import java.time.LocalDate;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.calendars.Calendar;
import jdplus.toolkit.base.api.timeseries.calendars.CalendarDefinition;
import jdplus.toolkit.base.api.timeseries.calendars.CalendarManager;
import jdplus.toolkit.base.api.timeseries.calendars.ChainedCalendar;
import jdplus.toolkit.base.api.timeseries.calendars.CompositeCalendar;
import jdplus.toolkit.base.api.timeseries.calendars.DayClustering;
import jdplus.toolkit.base.api.timeseries.regression.HolidaysCorrectedTradingDays;
import jdplus.toolkit.base.api.util.WeightedItem;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.CalendarCorrector;
import jdplus.toolkit.base.core.modelling.regression.ChainedCalendarCorrector;
import jdplus.toolkit.base.core.modelling.regression.CompositeCalendarCorrector;
import jdplus.toolkit.base.core.modelling.regression.GenericTradingDaysFactory;
import jdplus.toolkit.base.core.modelling.regression.RegressionVariableFactory;

public class HolidaysCorrectionFactory
implements RegressionVariableFactory<HolidaysCorrectedTradingDays> {
    public static HolidaysCorrectionFactory FACTORY = new HolidaysCorrectionFactory();
    private static final double AVG = 0.14285714285714285;

    public static HolidaysCorrectedTradingDays.HolidaysCorrector corrector(String name, CalendarManager mgr, DayOfWeek hol) {
        CalendarDefinition cur = (CalendarDefinition)mgr.get(name);
        if (cur == null) {
            return null;
        }
        return HolidaysCorrectionFactory.corrector(cur, mgr, hol);
    }

    public static HolidaysCorrectedTradingDays.HolidaysCorrector corrector(CalendarDefinition cur, CalendarManager mgr, DayOfWeek hol) {
        if (cur instanceof Calendar) {
            Calendar calendar = (Calendar)cur;
            return HolidaysCorrectionFactory.corrector(calendar, hol);
        }
        if (cur instanceof ChainedCalendar) {
            ChainedCalendar ccur = (ChainedCalendar)cur;
            HolidaysCorrectedTradingDays.HolidaysCorrector beg = HolidaysCorrectionFactory.corrector(ccur.getFirst(), mgr, hol);
            HolidaysCorrectedTradingDays.HolidaysCorrector end = HolidaysCorrectionFactory.corrector(ccur.getSecond(), mgr, hol);
            if (beg == null || end == null) {
                return null;
            }
            return HolidaysCorrectionFactory.corrector(beg, end, ccur.getBreakDate());
        }
        if (cur instanceof CompositeCalendar) {
            CompositeCalendar ccur = (CompositeCalendar)cur;
            WeightedItem[] calendars = ccur.getCalendars();
            HolidaysCorrectedTradingDays.HolidaysCorrector[] corr = new HolidaysCorrectedTradingDays.HolidaysCorrector[calendars.length];
            double[] weights = new double[calendars.length];
            for (int i = 0; i < calendars.length; ++i) {
                corr[i] = HolidaysCorrectionFactory.corrector((String)calendars[i].getItem(), mgr, hol);
                if (corr[i] == null) {
                    return null;
                }
                weights[i] = calendars[i].getWeight();
            }
            return HolidaysCorrectionFactory.corrector(corr, weights);
        }
        return null;
    }

    public static HolidaysCorrectedTradingDays.HolidaysCorrector corrector(Calendar calendar, DayOfWeek hol) {
        return new CalendarCorrector(calendar.getHolidays(), calendar.isMeanCorrection(), hol);
    }

    public static HolidaysCorrectedTradingDays.HolidaysCorrector corrector(HolidaysCorrectedTradingDays.HolidaysCorrector beg, HolidaysCorrectedTradingDays.HolidaysCorrector end, LocalDate breakDate) {
        return new ChainedCalendarCorrector(beg, end, breakDate);
    }

    public static HolidaysCorrectedTradingDays.HolidaysCorrector corrector(HolidaysCorrectedTradingDays.HolidaysCorrector[] correctors, double[] weights) {
        return new CompositeCalendarCorrector(correctors, weights);
    }

    private HolidaysCorrectionFactory() {
    }

    private boolean fillRaw(HolidaysCorrectedTradingDays.HolidaysCorrector corrector, DayClustering clustering, TsPeriod start, FastMatrix buffer) {
        int n = buffer.getRowsCount();
        TsDomain domain = TsDomain.of((TsPeriod)start, (int)n);
        FastMatrix days = FastMatrix.make(n, 7);
        GenericTradingDaysFactory.fillTradingDaysMatrix(start, false, days);
        Matrix corr = corrector.rawCorrection(domain);
        for (int i = 0; i < 7; ++i) {
            days.column(i).apply(corr.column(i), (a, b) -> a + b);
        }
        GenericTradingDaysFactory.fillNoContrasts(clustering, days, buffer);
        return true;
    }

    @Override
    public boolean fill(HolidaysCorrectedTradingDays var, TsPeriod start, FastMatrix buffer, ProcessingLog log) {
        return var.isContrast() ? this.fill(var.getCorrector(), var.getClustering(), var.isWeighted(), start, buffer) : this.fillRaw(var.getCorrector(), var.getClustering(), start, buffer);
    }

    private boolean fill(HolidaysCorrectedTradingDays.HolidaysCorrector corrector, DayClustering clustering, boolean weighted, TsPeriod start, FastMatrix buffer) {
        int n = buffer.getRowsCount();
        TsDomain domain = TsDomain.of((TsPeriod)start, (int)n);
        FastMatrix days = FastMatrix.make(n, 7);
        GenericTradingDaysFactory.fillTradingDaysMatrix(start, false, days);
        Matrix corr = corrector.holidaysCorrection(domain);
        for (int i = 0; i < 7; ++i) {
            DataBlock col = days.column(i);
            col.add(corr.column(i));
        }
        double[] weights = null;
        if (weighted) {
            DoubleSeq dc = corrector.longTermYearlyCorrection();
            weights = dc.toArray();
            for (int j = 0; j < weights.length; ++j) {
                weights[j] = 0.14285714285714285 + weights[j] / 365.25;
            }
        }
        GenericTradingDaysFactory.fillContrasts(clustering, days, buffer, weights);
        return true;
    }

    @Override
    public <P extends TimeSeriesInterval<?>, D extends TimeSeriesDomain<P>> boolean fill(HolidaysCorrectedTradingDays var, D domain, FastMatrix buffer, ProcessingLog log) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

