/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.symmbreaking;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;

public class PropSymmetryBreakingEx
extends Propagator<BoolVar> {
    private final int n;
    private final BoolVar[] t;

    public PropSymmetryBreakingEx(BoolVar[] t) {
        super((Variable[])t, (Priority)PropagatorPriority.CUBIC, false);
        this.n = (int)Math.round(Math.sqrt(t.length));
        this.t = t;
    }

    private Cmp compare(BoolVar a, BoolVar b) {
        if (a.isInstantiatedTo(0) && b.isInstantiatedTo(1)) {
            return Cmp.LESS;
        }
        if (a.isInstantiatedTo(0) && b.isInstantiatedTo(0) || a.isInstantiatedTo(1) && b.isInstantiatedTo(1)) {
            return Cmp.EQUALS;
        }
        if (a.isInstantiatedTo(1) && b.isInstantiatedTo(0)) {
            return Cmp.GREATER;
        }
        return Cmp.UNDEFINED;
    }

    private boolean lessOrEqualsEx(int j1, int j2) throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            Cmp cmp;
            if (i == j1 || i == j2) continue;
            if (this.t[i + j1 * this.n].isInstantiatedTo(1)) {
                this.t[i + j2 * this.n].instantiateTo(1, (ICause)this);
            }
            if ((cmp = this.compare(this.t[i + j1 * this.n], this.t[i + j2 * this.n])) == Cmp.LESS || cmp == Cmp.UNDEFINED) {
                return true;
            }
            if (cmp != Cmp.GREATER) continue;
            return false;
        }
        return true;
    }

    private boolean sortedEx() throws ContradictionException {
        for (int j = 1; j < this.n; ++j) {
            for (int i = 0; i < j; ++i) {
                if (j - i == 2 || this.lessOrEqualsEx(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (!this.sortedEx()) {
            throw new ContradictionException();
        }
    }

    @Override
    public ESat isEntailed() {
        try {
            if (!this.sortedEx()) {
                return ESat.FALSE;
            }
        }
        catch (ContradictionException e) {
            return ESat.FALSE;
        }
        for (BoolVar aT : this.t) {
            if (aT.isInstantiated()) continue;
            return ESat.UNDEFINED;
        }
        return ESat.TRUE;
    }

    private static enum Cmp {
        LESS,
        EQUALS,
        GREATER,
        UNDEFINED;

    }
}

