## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----echo=FALSE, out.width="100%", fig.align="center"-------------------------
knitr::include_graphics("figures/20250925_graphical_abstract_rChEA3_v1.png")

## ----setup--------------------------------------------------------------------
library(rChEA3)

## ----submit-------------------------------------------------------------------
genes <- c("TP53", "ESR1", "MYC", "NIPBL", "BRCA1")
results <- queryChEA3(genes)

## ----inspect------------------------------------------------------------------
displayTopN(results)

## ----extract------------------------------------------------------------------
meanRank_results <- results[["Integrated--meanRank"]]
head(meanRank_results)

## ----visualize----------------------------------------------------------------
visualizeRank(meanRank_results)

## ----session-info-------------------------------------------------------------
sessionInfo()

