/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r.Scenario;

import com.conveyal.r5.analyst.scenario.Modification;
import com.conveyal.r5.streets.EdgeStore;
import com.conveyal.r5.transit.TransportNetwork;
import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.set.hash.TLongHashSet;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetLtsOsm
extends Modification {
    private static final Logger LOG = LoggerFactory.getLogger(SetLtsOsm.class);
    public HashMap<Long, Integer> ltsMap;

    public boolean resolve(TransportNetwork network) {
        TLongHashSet osmIdSet = new TLongHashSet();
        for (int i = 0; i < network.streetLayer.edgeStore.osmids.size(); ++i) {
            osmIdSet.add(network.streetLayer.edgeStore.osmids.get(i));
        }
        TLongArrayList badIds = new TLongArrayList();
        for (Long osmId : this.ltsMap.keySet()) {
            if (osmIdSet.contains(osmId.longValue())) continue;
            badIds.add(osmId.longValue());
        }
        if (!badIds.isEmpty()) {
            LOG.warn("Cannot find the following OSM IDs in network: {}", (Object)badIds);
        }
        return this.hasErrors();
    }

    public boolean apply(TransportNetwork network) {
        LOG.info("Setting LTS levels by OSM id...");
        network.streetLayer.edgeStore.flags = new TIntArrayList((TIntCollection)network.streetLayer.edgeStore.flags);
        EdgeStore edgeStore = network.streetLayer.edgeStore;
        EdgeStore.Edge edge = edgeStore.getCursor();
        while (edge.advance()) {
            int lts = this.ltsMap.getOrDefault(edge.getOSMID(), 0);
            if (lts == 0) continue;
            edge.setFlag(EdgeStore.EdgeFlag.BIKE_LTS_EXPLICIT);
            edge.setLts(lts);
        }
        return this.hasErrors();
    }

    public int getSortOrder() {
        return 95;
    }

    public boolean affectsStreetLayer() {
        return true;
    }

    public boolean affectsTransitLayer() {
        return false;
    }
}

